#ifndef __CANOPEN_APS_ERROR_H
#define __CANOPEN_APS_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// CANopen Slave Application  Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_CANOPEN_APS_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_CANOPEN_APS_COMMAND_INVALID ((TLR_RESULT)0xC04A0001L)

//
// MessageId: TLR_E_CANOPEN_APS_DATABASE_FOUND
//
// MessageText:
//
//  Configuration database found.
//
#define TLR_E_CANOPEN_APS_DATABASE_FOUND ((TLR_RESULT)0xC04A0002L)

//
// MessageId: TLR_E_CANOPEN_APS_NODE_ID_PARAMETER
//
// MessageText:
//
//  Invalid parameter for node id.
//
#define TLR_E_CANOPEN_APS_NODE_ID_PARAMETER ((TLR_RESULT)0xC04A0003L)

//
// MessageId: TLR_E_CANOPEN_APS_BAUDRATE_PARAMETER
//
// MessageText:
//
//  Invalid parameter for baudrate.
//
#define TLR_E_CANOPEN_APS_BAUDRATE_PARAMETER ((TLR_RESULT)0xC04A0004L)

//
// MessageId: TLR_E_CANOPEN_APS_STATE
//
// MessageText:
//
//  Request not possible in current state.
//
#define TLR_E_CANOPEN_APS_STATE          ((TLR_RESULT)0xC04A0005L)

//
// MessageId: TLR_E_CANOPEN_APS_REQUEST_RUNNING
//
// MessageText:
//
//  Request already running.
//
#define TLR_E_CANOPEN_APS_REQUEST_RUNNING ((TLR_RESULT)0xC04A0006L)

//
// MessageId: TLR_I_CANOPEN_APS_OPEN_DBM_FILE
//
// MessageText:
//
//  Failed to open configuration database.
//
#define TLR_I_CANOPEN_APS_OPEN_DBM_FILE  ((TLR_RESULT)0x404A0007L)

//
// MessageId: TLR_E_CANOPEN_APS_DATASET
//
// MessageText:
//
//  Failed to open configuration dataset.
//
#define TLR_E_CANOPEN_APS_DATASET        ((TLR_RESULT)0xC04A0008L)

//
// MessageId: TLR_E_CANOPEN_APS_TABLE_GLOBAL
//
// MessageText:
//
//  Failed to open 'GLOBAL' configuration dataset.
//
#define TLR_E_CANOPEN_APS_TABLE_GLOBAL   ((TLR_RESULT)0xC04A0009L)

//
// MessageId: TLR_E_CANOPEN_APS_TABLE_BUS_CAN
//
// MessageText:
//
//  Failed to open 'BUS_CAN' configuration dataset.
//
#define TLR_E_CANOPEN_APS_TABLE_BUS_CAN  ((TLR_RESULT)0xC04A000AL)

//
// MessageId: TLR_E_CANOPEN_APS_SIZE_TABLE_BUS_CAN
//
// MessageText:
//
//  Invalid size of 'BUS_CAN' configuration dataset.
//
#define TLR_E_CANOPEN_APS_SIZE_TABLE_BUS_CAN ((TLR_RESULT)0xC04A000BL)

//
// MessageId: TLR_I_CANOPEN_APS_CONFIG_LOCK
//
// MessageText:
//
//  Configuration is locked.
//
#define TLR_I_CANOPEN_APS_CONFIG_LOCK    ((TLR_RESULT)0x404A000CL)

//
// MessageId: TLR_E_CANOPEN_APS_PACKET_LENGTH
//
// MessageText:
//
//  Invalid packet length.
//
#define TLR_E_CANOPEN_APS_PACKET_LENGTH  ((TLR_RESULT)0xC04A000DL)

//
// MessageId: TLR_E_CANOPEN_APS_WATCHDOG_PARAMETER
//
// MessageText:
//
//  Invalid parameter for watchdog supervision.
//
#define TLR_E_CANOPEN_APS_WATCHDOG_PARAMETER ((TLR_RESULT)0xC04A000EL)

//
// MessageId: TLR_E_CANOPEN_APS_WATCHDOG_ACTIVATE
//
// MessageText:
//
//  Failed to activate watchdog supervision.
//
#define TLR_E_CANOPEN_APS_WATCHDOG_ACTIVATE ((TLR_RESULT)0xC04A000FL)

//
// MessageId: TLR_E_CANOPEN_APS_PARAM_QUEUE_ELEMENT
//
// MessageText:
//
//  Invalid parameter for number of queue elements.
//
#define TLR_E_CANOPEN_APS_PARAM_QUEUE_ELEMENT ((TLR_RESULT)0xC04A0010L)

//
// MessageId: TLR_E_CANOPEN_APS_PARAM_POOL_ELEMENT
//
// MessageText:
//
//  Invalid parameter for number of pool elements.
//
#define TLR_E_CANOPEN_APS_PARAM_POOL_ELEMENT ((TLR_RESULT)0xC04A0011L)

//
// MessageId: TLR_E_CANOPEN_APS_PARAM_CYCLETIME
//
// MessageText:
//
//  Invalid parameter for cycletime.
//
#define TLR_E_CANOPEN_APS_PARAM_CYCLETIME ((TLR_RESULT)0xC04A0012L)

//
// MessageId: TLR_E_CANOPEN_APS_PARAM_CHN_INSTANCE
//
// MessageText:
//
//  Invalid parameter for channel instance.
//
#define TLR_E_CANOPEN_APS_PARAM_CHN_INSTANCE ((TLR_RESULT)0xC04A0013L)

//
// MessageId: TLR_E_CANOPEN_APS_NUM_OF_RX_PDO_PARAMETER
//
// MessageText:
//
//  Invalid parameter for number of receive PDO.
//
#define TLR_E_CANOPEN_APS_NUM_OF_RX_PDO_PARAMETER ((TLR_RESULT)0xC04A0014L)

//
// MessageId: TLR_E_CANOPEN_APS_NUM_OF_TX_PDO_PARAMETER
//
// MessageText:
//
//  Invalid parameter for number of send PDO.
//
#define TLR_E_CANOPEN_APS_NUM_OF_TX_PDO_PARAMETER ((TLR_RESULT)0xC04A0015L)

//
// MessageId: TLR_E_CANOPEN_APS_SIZE_TABLE_VERSION
//
// MessageText:
//
//  Invalid size of table 'Version'.
//
#define TLR_E_CANOPEN_APS_SIZE_TABLE_VERSION ((TLR_RESULT)0xC04A0016L)

//
// MessageId: TLR_E_CANOPEN_APS_INVALID_DBM_VERSION
//
// MessageText:
//
//  Invalid version of table 'Version'.
//
#define TLR_E_CANOPEN_APS_INVALID_DBM_VERSION ((TLR_RESULT)0xC04A0017L)

//
// MessageId: TLR_E_CANOPEN_APS_SIZE_TABLE_BUS_CAN_STD
//
// MessageText:
//
//  Invalid size of table 'BUS_COS_STD'.
//
#define TLR_E_CANOPEN_APS_SIZE_TABLE_BUS_CAN_STD ((TLR_RESULT)0xC04A0018L)

//
// MessageId: TLR_E_CANOPEN_APS_SIZE_TABLE_BUS_CAN_EXT
//
// MessageText:
//
//  Invalid size of table 'BUS_COS_EXT'.
//
#define TLR_E_CANOPEN_APS_SIZE_TABLE_BUS_CAN_EXT ((TLR_RESULT)0xC04A0019L)

//
// MessageId: TLR_E_CANOPEN_APS_AUTOSTART_WITH_EXTENDED_MODE
//
// MessageText:
//
//  Autostart not allowed in extended mode.
//
#define TLR_E_CANOPEN_APS_AUTOSTART_WITH_EXTENDED_MODE ((TLR_RESULT)0xC04A001AL)

//
// MessageId: TLR_E_CANOPEN_APS_ADDRESS_SWITCH_CONFIGURATION_NOT_POSSIBLE
//
// MessageText:
//
//  Address switch configuration is not possible.
//
#define TLR_E_CANOPEN_APS_ADDRESS_SWITCH_CONFIGURATION_NOT_POSSIBLE ((TLR_RESULT)0xC04A001BL)

//
// MessageId: TLR_E_CANOPEN_APS_BAUD_SWITCH_CONFIGURATION_NOT_POSSIBLE
//
// MessageText:
//
//  Baud switch configuration is not possible.
//
#define TLR_E_CANOPEN_APS_BAUD_SWITCH_CONFIGURATION_NOT_POSSIBLE ((TLR_RESULT)0xC04A001CL)

//
// MessageId: TLR_E_CANOPEN_APS_PARAM_LED_MODE
//
// MessageText:
//
//  Invalid parameter for LED mode.
//
#define TLR_E_CANOPEN_APS_PARAM_LED_MODE ((TLR_RESULT)0xC04A001DL)




#endif  //__CANOPEN_APS_ERROR_H

